using UnityEngine;
using System;
namespace hive
{
    /// <summary>
    /// Hive 플러그인 DLL을 로드할 디렉터리 경로를 제공합니다.
    /// </summary>
    internal static class HivePluginDirectory
    {
        /// <summary>
        /// Hive 플러그인 DLL이 위치한 디렉터리 경로입니다.
        /// </summary>
        public static readonly string[] HiveServiceSearchPath = {
            System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory),
            System.IO.Path.Combine(Application.streamingAssetsPath,
                                    HiveUnityPluginStandaloneWindowsConst.HIVE_SDK_LOAD_FROM_STREAMING_ASSETS_DIRECTORY)
        };

        public static readonly string[] HivePluginsSearchPath = {
            System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "plugins"),
            System.IO.Path.Combine(Application.streamingAssetsPath,
                                    HiveUnityPluginStandaloneWindowsConst.HIVE_SDK_LOAD_FROM_STREAMING_ASSETS_DIRECTORY,
                                    "plugins")
        };
    }
}